from libs.AutoToolsLib import AutoToolsLib
import json
import pypinyin
from unidecode import unidecode

class AutoTools(AutoToolsLib):
    def __init__(self):
        pass

    def FormData(self):
        # 此处编写用户填写表单
        FormData = [
            self.FormControl.PushButton('InputJsonPaths', '方块模型json', 'JsonPaths', '选择多个json文件...'),
            self.FormControl.PushButton('BehaviorPackPath', '行为包路径', 'FolderPath', '选择文件夹...'),
            self.FormControl.PushButton('ResourcePackPath', '资源包路径', 'FolderPath', '选择文件夹...'),
            # self.FormControl.ComboBox('IsOffset', '模型是否偏移', None, ['是', '否']),
        ]
        return FormData

    def FormCommit(self, FormData):
        BehaviorPackPath, ResourcePackPath = FormData['BehaviorPackPath'], FormData['ResourcePackPath']
        RunLogic = [
            self.Create.CreateFolder(ResourcePackPath + '/models'),
            self.Create.CreateFolder(ResourcePackPath + '/models/netease_block'),
            self.Create.CreateFolder(ResourcePackPath + '/textures/'),
            self.Create.CreateFolder(ResourcePackPath + '/textures/blocks'),
            self.Create.CreateFolder(BehaviorPackPath + '/netease_blocks'),
        ]

        for JsonPath in FormData['InputJsonPaths']:
            JsonFolderPath = '/'.join(JsonPath.split('/')[:-1])
            with open(JsonPath, 'r', encoding='utf-8') as f:
                BlockChineseName = JsonPath.split('/')[-1].split('.')[0]
                BlockName = self.ChineseConvertToPinYin(BlockChineseName)
                JsonDict = json.load(f)
                NewJsonDict = self.BedrockBlockGeoJsonConvertNeteaseBlockGeoJson(JsonDict, BlockName)
                RunLogic.append(self.Create.CreateJson(ResourcePackPath + f'/models/netease_block/{BlockName}.json', NewJsonDict))
                RunLogic.append(self.Other.CopyFile(JsonFolderPath + f'/{BlockChineseName}.png', ResourcePackPath + f'/textures/blocks/', f'{BlockName}.png'))
                RunLogic.append(self.MinecraftOrigin.Blocks(ResourcePackPath + '/blocks.json', f'dfm:{BlockName}', {
                    'model_textures': [f'dfm:{BlockName}_1'],
                    'netease_model': f'dfm:{BlockName}',
                    'sound': 'bamboo_sapling',
                    'textures': f'dfm:{BlockName}_1'
                }))
                RunLogic.append(self.MinecraftOrigin.TerrainTexture(ResourcePackPath + '/textures/terrain_texture.json', f'dfm:{BlockName}_1', {
                    'textures': f'textures/blocks/{BlockName}'
                }))
                RunLogic.append(self.Create.CreateJson(BehaviorPackPath + f'/netease_blocks/dfm_{BlockName}.json', self.GetBehaviorPackBlockJsonDemo(BlockName)))
                RunLogic.append(self.Other.AddLines(ResourcePackPath + f'/texts/zh_CN.lang', f'tile.dfm:{BlockName}.name={BlockChineseName}\n'))
        return RunLogic

    def ChineseConvertToPinYin(self, Chinese):
        # 将中文转换为小写拼音，且不带声调
        PinYinList = pypinyin.lazy_pinyin(Chinese, style=pypinyin.NORMAL)
        PinYinName = ''.join(PinYinList)
        # 转换特殊字符为 ASCII
        PinYin = unidecode(PinYinName)
        return PinYin

    def GetBehaviorPackBlockJsonDemo(self, BlockName):
        """获取行为包自定义方块json"""
        with open('/dfmAutoDev/plugins/custommodelblocks/dfm_dabaicai.json', 'r', encoding='utf-8') as f:
            JsonDict = json.load(f)
            JsonDict['minecraft:block']['description']['identifier'] = f'dfm:{BlockName}'
            return JsonDict

    def BedrockBlockGeoJsonConvertNeteaseBlockGeoJson(self, JsonDict, BlockName, IsOffset=True):
        """基岩版方块模型转化为中国版方块模型"""
        Description, Bones = {}, []
        for Key, Dict in JsonDict['minecraft:geometry'][0].items():
            if Key == 'description':
                Description = Dict
            elif Key == 'bones':
                if IsOffset:
                    Bones = Dict
                else:
                    for BonesDict in Dict:
                        NewBonesDict = {
                            'name': BonesDict['name'],
                            'pivot': BonesDict.get('pivot', [0, 0, 0]),
                            'cubes': []
                        }
                        for CubesDict in BonesDict.get('cubes', []):
                            OriginPosition = CubesDict['origin']
                            CubesDict['origin'] = [OriginPosition[0] - 8, OriginPosition[1], OriginPosition[2] + 8]
                            NewBonesDict['cubes'].append(CubesDict)
                        Bones.append(NewBonesDict)
        
        NewJsonDict = {
            'format_version': '1.13.0',
            'netease:block_geometry': {
                'description': {
                    'identifier': f'dfm:{BlockName}',
                    'textures': [f'dfm:{BlockName}_1'],
                    'textures_descriptions': [{
                        'length': Description['texture_height'],
                        'width': Description['texture_width'],
                    }],
                    'use_ao': False
                },
                'bones': Bones
            }
        }
        return NewJsonDict 