from libs.AutoToolsLib import AutoToolsLib
import json, pypinyin, os
from unidecode import unidecode
import copy

class AutoTools(AutoToolsLib):
    def __init__(self):
        pass

    def FormData(self):
        # 此处编写用户填写表单
        FormData = [
            self.FormControl.PushButton('DoomsZItemFolderPath', '绝地惊变物品文件', 'JsonPaths', '选择Json文件...'),
            self.FormControl.PushButton('BehaviorPackPath', '行为包路径', 'FolderPath', '选择文件夹...'),
            self.FormControl.PushButton('ResourcePackPath', '资源包路径', 'FolderPath', '选择文件夹...'),
        ]
        return FormData

    def FormCommit(self, FormData):
        DoomsZItemFolderPath = FormData['DoomsZItemFolderPath']
        BehaviorPackPath = FormData['BehaviorPackPath']
        ResourcePackPath = FormData['ResourcePackPath']
        ItemStateLang = {
            0: '§c报废',
            1: '§6严重破损',
            2: '§e破损',
            3: '§2较新',
            4: '§a全新'
        }

        with open('/dfmAutoDev/plugins/CreateAttachableItems/common/doomszitem.render_controllers.json', 'r', encoding='utf-8') as f:
            RenderControllerDict = json.load(f)
        with open('/dfmAutoDev/plugins/CreateAttachableItems/common/doomszitem.animation.json', 'r', encoding='utf-8') as f:
            AnimationDict = json.load(f)
        RunLogic = [
            self.Create.CreateFolder(BehaviorPackPath + '/entities'),
            self.Create.CreateFolder(BehaviorPackPath + '/netease_items_beh'),
            self.Create.CreateFolder(ResourcePackPath + '/animations'),
            self.Create.CreateFolder(ResourcePackPath + '/attachables'),
            self.Create.CreateFolder(ResourcePackPath + '/entity'),
            self.Create.CreateFolder(ResourcePackPath + '/models'),
            self.Create.CreateFolder(ResourcePackPath + '/models/entity'),
            self.Create.CreateFolder(ResourcePackPath + '/netease_items_res'),
            self.Create.CreateFolder(ResourcePackPath + '/render_controllers'),
            self.Create.CreateFolder(ResourcePackPath + '/texts'),
            self.Create.CreateFolder(ResourcePackPath + '/textures'),
            self.Create.CreateFolder(ResourcePackPath + '/textures/entity'),
            self.Create.CreateFolder(ResourcePackPath + '/textures/items'),
            self.Create.CreateJson(ResourcePackPath + '/render_controllers/doomszitem.render_controllers.json', RenderControllerDict),
            self.Create.CreateJson(ResourcePackPath + '/animations/doomszitem.animation.json', AnimationDict),
        ]
        for GeoJsonPath in FormData['DoomsZItemFolderPath']:
            JsonFolderPath = '/'.join(GeoJsonPath.split('/')[:-1])
            with open(GeoJsonPath, 'r', encoding='utf-8') as f:
                ItemChineseName = GeoJsonPath.split('/')[-1].split('.')[0]
                ItemName = self.ChineseConvertToPinYin(ItemChineseName)
                GeoJsonDict = json.load(f)
                try:
                    # 实体模型文件的导入
                    # 深拷贝 GeoJsonDict 避免修改互相影响
                    EntityGeoJsonDict = copy.deepcopy(GeoJsonDict)
                    EntityGeoJsonDict['minecraft:geometry'][0]['description']['identifier'] = f'geometry.{ItemName}_entity'
                    RunLogic.append(self.Create.CreateJson(ResourcePackPath + f'/models/entity/{ItemName}_entity.geo.json', EntityGeoJsonDict))
                    # 物品模型文件的导入，需要进行偏移修改
                    ItemGeoJsonDict = copy.deepcopy(GeoJsonDict)
                    ItemGeoJsonDict['minecraft:geometry'][0]['description']['identifier'] = f'geometry.{ItemName}_item'
                    ItemGeoJsonDict = self.EntityModelConvertToAttachModel(ItemGeoJsonDict)
                    RunLogic.append(self.Create.CreateJson(ResourcePackPath + f'/models/entity/{ItemName}_item.geo.json', ItemGeoJsonDict))
                except Exception as e:
                    with open('/dfmAutoDev/latest.log', 'a', encoding='utf-8') as log_file:
                        log_file.write(f'写入模型文件时出错: {str(e)}\n')
                        continue
                
                for i in range(0, 5):
                    # 实体行为包
                    with open('/dfmAutoDev/plugins/CreateAttachableItems/dfm_custom_item_entity.json', 'r', encoding='utf-8') as f:
                        BehEntityJsonDemo = json.load(f)
                        BehEntityJsonDemo['minecraft:entity']['description']['identifier'] = f'doomsz:{ItemName}_entity_{i}'
                        RunLogic.append(self.Create.CreateJson(BehaviorPackPath + f'/entities/{ItemName}_entity_{i}.json', BehEntityJsonDemo))
                    # 实体资源包
                    with open('/dfmAutoDev/plugins/CreateAttachableItems/resdfm_custom_item_entity.json', 'r', encoding='utf-8') as f:
                        ResEntityJsonDemo = json.load(f)
                        ResEntityJsonDemo['minecraft:client_entity']['description']['identifier'] = f'doomsz:{ItemName}_entity_{i}'
                        ResEntityJsonDemo['minecraft:client_entity']['description']['geometry']['default'] = f'geometry.{ItemName}_entity'
                        ResEntityJsonDemo['minecraft:client_entity']['description']['textures']['default'] = f'textures/entity/{ItemName}_{i}.png'
                        RunLogic.append(self.Create.CreateJson(ResourcePackPath + f'/entity/{ItemName}_entity_{i}.json', ResEntityJsonDemo))
                    # 实体贴图
                    RunLogic.append(self.Other.CopyFile(JsonFolderPath + f'/{ItemChineseName}_{i}.png', ResourcePackPath + f'/textures/entity/', f'{ItemName}_{i}.png'))
                    # 物品
                    with open('/dfmAutoDev/plugins/CreateAttachableItems/dfm_custom_item.json', 'r', encoding='utf-8') as f:
                        BehItemJsonDemo = json.load(f)
                        BehItemJsonDemo['minecraft:item']['description']['identifier'] = f'doomsz:{ItemName}_item_{i}'
                        BehItemJsonDemo['minecraft:item']['components']['netease:customtips']['value'] = f'{ItemStateLang[i]}的{ItemChineseName}'
                        RunLogic.append(self.Create.CreateJson(BehaviorPackPath + f'/netease_items_beh/{ItemName}_item_{i}.json', BehItemJsonDemo))
                    # 物品附着物
                    with open('/dfmAutoDev/plugins/CreateAttachableItems/resdfm_custom_item.json', 'r', encoding='utf-8') as f:
                        ResAttachJsonDemo = json.load(f)
                        ResAttachJsonDemo['minecraft:attachable']['description']['identifier'] = f'doomsz:{ItemName}_item_{i}'
                        ResAttachJsonDemo['minecraft:attachable']['description']['geometry']['default'] = f'geometry.{ItemName}_item'
                        ResAttachJsonDemo['minecraft:attachable']['description']['textures']['default'] = f'textures/entity/{ItemName}_{i}.png'
                        RunLogic.append(self.Create.CreateJson(ResourcePackPath + f'/attachables/{ItemName}_item_{i}.json', ResAttachJsonDemo))
                    # 物品贴图
                    RunLogic.append(self.Other.CopyFile(JsonFolderPath + f'/{ItemChineseName}_icon_{i}.png', ResourcePackPath + f'/textures/items/', f'{ItemName}_{i}.png'))
                    # 物品贴图定义
                    RunLogic.append(self.MinecraftOrigin.ItemTexture(ResourcePackPath + '/textures/item_texture.json', f'doomsz:{ItemName}_item_{i}', {'textures': f'textures/items/{ItemName}_{i}'}))
                    # 物品资源包
                    ResItemJsonDict = {
                        "format_version": "1.10",
                        "minecraft:item": {
                            "components": {
                                "minecraft:icon": f'doomsz:{ItemName}_item_{i}'
                            },
                            "description": {
                                "identifier": f'doomsz:{ItemName}_item_{i}'
                            }
                        }
                    }
                    RunLogic.append(self.Create.CreateJson(ResourcePackPath + f'/netease_items_res/doomsz_{ItemName}_item_{i}.json', ResItemJsonDict))
                    # 翻译名称
                    RunLogic.append(self.Other.AddLines(ResourcePackPath + f'/texts/zh_CN.lang', f'item.doomsz:{ItemName}_item_{i}.name={ItemChineseName}\n'))
        return RunLogic

    def EntityModelConvertToAttachModel(self, GeoJsonDict):
        OldBonesList = GeoJsonDict['minecraft:geometry'][0]['bones']
        OldCubeDict = {}
        for CubeDict in OldBonesList:
            if CubeDict['name'] in ['root', 'bb_main']:
                CubeDict['name'] = 'DoomsZItem'
                CubeDict['parent'] = 'rightItem'
                CubeDict['pivot'] = [0, 0, 0]
                OldCubeDict = CubeDict
                break
        if not OldCubeDict:
            return {}
        with open('/dfmAutoDev/plugins/CreateAttachableItems/dfm_custom_item.geo.json', 'r', encoding='utf-8') as f:
            DemoJsonDict = json.load(f)
            GeoJsonDict['minecraft:geometry'][0]['bones'] = DemoJsonDict['minecraft:geometry'][0]['bones']
            GeoJsonDict['minecraft:geometry'][0]['bones'].append(OldCubeDict)
            return GeoJsonDict
        
    def ChineseConvertToPinYin(self, Chinese):
        # 将中文转换为小写拼音，且不带声调
        PinYinList = pypinyin.lazy_pinyin(Chinese, style=pypinyin.NORMAL)
        PinYinName = ''.join(PinYinList)
        # 转换特殊字符为 ASCII
        PinYin = unidecode(PinYinName)
        return PinYin