from libs.AutoToolsLib import AutoToolsLib

class AutoTools(AutoToolsLib):
    def __init__(self):
        pass

    def FormData(self):
        # 此处编写用户填写表单
        FormData = [
            self.FormControl.LineEdit('NameSpace', '命名空间', 'item_str', 'dfm'),
            self.FormControl.LineEdit('EntityName', '实体注册ID', 'item_str', ''),
            self.FormControl.LineEdit('Health', '生命值', 'int', '100'),
            self.FormControl.LineEdit('Scale', '大小倍率', 'float', '1'),
            self.FormControl.LineEdit('BoxWidth', '碰撞箱宽度', 'float', ''),
            self.FormControl.LineEdit('BoxHeight', '碰撞箱高度', 'float', ''),
            self.FormControl.LineEdit('Damage', '伤害', 'float', ''),
            self.FormControl.LineEdit('AttackTimer', '普通攻击动画时长', 'float', ''),
            self.FormControl.LineEdit('DamgeTimer', '造成伤害时长', 'float', ''),
            self.FormControl.ComboBox('IsPatrol', '是否会自行巡逻移动', None, ['是', '否']),
            self.FormControl.PushButton('Model', '模型文件', 'JsonValue', '选择模型Geo的Json文件'),
            self.FormControl.PushButton('TexturePath', '贴图文件', 'PngPath', '选择模型贴图PNG文件'),
            self.FormControl.PushButton('Animation', '动画文件', 'JsonValue', '选择模型动画的Json文件'),
            self.FormControl.PushButton('BehaviorPackPath', '行为包路径', 'FolderPath', '选择文件夹...'),
            self.FormControl.PushButton('ResourcePackPath', '资源包路径', 'FolderPath', '选择文件夹...'),
        ]
        return FormData

    def FormCommit(self, FormData):
        # 此处编写用户填写表单后，点击确认后的逻辑
        RunLogic = []
        NameSpace, EntityName, Health, Scale, BoxWidth, BoxHeight, Damage, AttackTimer, DamgeTimer, IsPatrol, Model, TexturePath, Animation = FormData['NameSpace'], FormData['EntityName'], FormData['Health'], FormData['Scale'], FormData['BoxWidth'], FormData['BoxHeight'], FormData['Damage'], FormData['AttackTimer'], FormData['DamgeTimer'], FormData['IsPatrol'], FormData['Model'], FormData['TexturePath'], FormData['Animation']
        BehaviorPackPath, ResourcePackPath = FormData['BehaviorPackPath'], FormData['ResourcePackPath']
        BehaviorPackEntityPath = BehaviorPackPath + '/entities'
        BehaviorPackDeathEntityPath = BehaviorPackEntityPath + '/death'
        ResourcePackEntityPath = ResourcePackPath + '/entity'
        ResourcePackDeathEntityPath = ResourcePackPath + '/entity/death'
        ResourcePackAnimationControllersPath = ResourcePackPath + '/animation_controllers'
        ResourcePackAnimationsPath = ResourcePackPath + '/aniamtions'
        ResourcePackModelsPath = ResourcePackPath + '/models/entity'
        ResourcePackTexturesPath = ResourcePackPath + '/textures/entity/'
        ResourcePackRenderControllersPath = ResourcePackPath + '/render_controllers'
        # 检测
        RunLogic.append(self.Create.CreateFolder(BehaviorPackEntityPath))
        RunLogic.append(self.Create.CreateFolder(BehaviorPackDeathEntityPath))
        RunLogic.append(self.Create.CreateFolder(ResourcePackEntityPath))
        RunLogic.append(self.Create.CreateFolder(ResourcePackDeathEntityPath))
        RunLogic.append(self.Create.CreateFolder(ResourcePackAnimationControllersPath))
        RunLogic.append(self.Create.CreateFolder(ResourcePackAnimationsPath))
        RunLogic.append(self.Create.CreateFolder(ResourcePackModelsPath))
        RunLogic.append(self.Create.CreateFolder(ResourcePackTexturesPath))
        RunLogic.append(self.Create.CreateFolder(ResourcePackRenderControllersPath))
        # 行为包实体
        if IsPatrol == '是':
            RunLogic.append(self.Create.CreateJson(BehaviorPackEntityPath + f'/{EntityName}.json', self.GetBPCustomComboEntityJsonDemo(NameSpace, EntityName, Health, Scale, BoxWidth, BoxHeight, Damage, AttackTimer, DamgeTimer)))
        else:
            RunLogic.append(self.Create.CreateJson(BehaviorPackEntityPath + f'/{EntityName}.json', self.GetBPCustomComboEntityJsonDemo2(NameSpace, EntityName, Health, Scale, BoxWidth, BoxHeight, Damage, AttackTimer, DamgeTimer)))
        # 空气实体
        RunLogic.append(self.Create.CreateJson(BehaviorPackDeathEntityPath + '/air.json', self.GetBPAirEntityJsonDemo()))
        # 死亡实体
        RunLogic.append(self.Create.CreateJson(BehaviorPackDeathEntityPath + f'/{EntityName}.json', self.GetBPCustomBossDeathEntityJsonDemo(NameSpace, EntityName, '1', Scale)))
        # 资源包实体
        RunLogic.append(self.Create.CreateJson(ResourcePackEntityPath + f'/{EntityName}.json', self.GetRPCustomComboEntityJsonDemo(NameSpace, EntityName)))
        # 资源包死亡实体
        RunLogic.append(self.Create.CreateJson(ResourcePackDeathEntityPath + f'/{EntityName}.json', self.GetRPCustomBossDeathEntityJsonDemo(NameSpace, EntityName)))
        # 资源包动画控制器
        RunLogic.append(self.Create.CreateJson(ResourcePackAnimationControllersPath + f'/{EntityName}.animation_controllers.json', self.GetRPCustomBossAnimationControllersJsonDemo(NameSpace, EntityName)))
        # 资源包动画
        AnimationIdList = []
        AnimationDict = Animation['animations']
        AnimtionJson = {
            "format_version": Animation['format_version'],
            "animations": {}
        }
        for OldAnimationName, Value in AnimationDict.items():
            AnimationId = OldAnimationName.split('.')[-1]
            AnimationIdList.append(AnimationId)
            NewAnimationName = f'animation.{EntityName}.{AnimationId}'
            AnimtionJson['animations'][NewAnimationName] = Value
        RunLogic.append(self.Create.CreateJson(ResourcePackAnimationsPath + f'/{EntityName}.animations.json', AnimtionJson))
        # 资源包模型
        try:
            Model["minecraft:geometry"][0]['description']['identifier'] = f'geometry.{EntityName}'
        except:
            pass
        RunLogic.append(self.Create.CreateJson(ResourcePackModelsPath + f'/{EntityName}.geo.json', Model))
        # 资源包渲染控制器
        RunLogic.append(self.Create.CreateJson(ResourcePackRenderControllersPath + f'/auto.render_controllers.json', self.GetRPBatteryRenderControllerJsonDemo()))
        # 资源包贴图
        RunLogic.append(self.Other.CopyFile(TexturePath, ResourcePackTexturesPath, f'{EntityName}.png'))
        return RunLogic

    def GetBPCustomComboEntityJsonDemo(self, NameSpace, EntityName, Health, Scale, Width, Height, Damage, AttackTimer, DamageTimer):
        """内置于此，以便服务端使用"""
        JsonDemo = {
            "format_version": "1.20.0",
            "minecraft:entity": {
                "description": {
                    "identifier": f"{NameSpace}:{EntityName}",
                    "is_spawnable": True,
                    "is_summonable": True,
                    "is_experimental": False
                },
                "component_groups": {
                    "dfm:start": {
                        "minecraft:is_tamed": {},
                        "minecraft:damage_sensor": {
                            "triggers": {
                                "cause": "fall2",
                                "deals_damage": False
                            }
                        },
                        "minecraft:timer": {
                            "looping": False,
                            "time": 2.2,
                            "time_down_event": {
                                "event": "dfm:start"
                            }
                        }
                    },
                    "dfm:is_hurt": {
                        "minecraft:is_shaking": {},
                        "minecraft:movement": {
                            "value": 0.00
                        }
                    },
                    "dfm:attack_cd": {
                        "minecraft:movement": {
                            "value": 0.00
                        },
                        "minecraft:timer": {
                            "looping": False,
                            "time": 3,
                            "time_down_event": {
                                "event": "dfm:stop_attack_cd_and_try_to_attack"
                            }
                        }
                    },
                    "dfm:death": {
                        "minecraft:transformation": {
                            "into": f"dfm:{EntityName}_death",
                            "drop_equipment": True,
                            "delay": {
                                "value": 0
                            }
                        }
                    },
                    "dfm:alive": {
                        "minecraft:breathable": {
                            "total_supply": 15,
                            "suffocate_time": 0,
                            "breathes_air": True,
                            "breathes_water": False
                        },
                        "minecraft:type_family": {
                            "family": [
                                "monster",
                                "mob"
                            ]
                        },
                        "minecraft:behavior.hurt_by_target": {
                            "hurt_owner": True,
                            "entity_types": [
                                {
                                    "filters": {
                                        "any_of": [
                                            {
                                                "test": "is_family",
                                                "subject": "other",
                                                "operator": "!=",
                                                "value": "monster"
                                            }
                                        ]
                                    },
                                    "max_dist": 35
                                }
                            ]
                        },
                        "minecraft:collision_box": {
                            "width": float(Width),
                            "height": float(Height)
                        }
                    },
                    "dfm:normal_state": {
                        "minecraft:behavior.look_at_player": {
                            "priority": 8,
                            "look_distance": 6,
                            "probability": 0.02
                        },
                        "minecraft:behavior.random_look_around": {
                            "priority": 9
                        },
                        "minecraft:behavior.float": {},
                        "minecraft:movement.basic": {},
                        "minecraft:navigation.walk": {
                            "is_amphibious": True,
                            "can_path_over_water": True,
                            "can_pass_doors": True,
                            "can_open_doors": True,
                            "can_walk": True,
                            "avoid_water": False
                        },
                        "minecraft:annotation.open_door": {},
                        "minecraft:jump.static": {}
                    },
                    "dfm:try_to_attack": {
                        "minecraft:attack": {
                            "damage": int(Damage)
                        },
                        "minecraft:behavior.delayed_attack": {
                            "priority": 3,
                            "speed_multiplier": 1.1,
                            "attack_once": False,
                            "require_complete_path": False,
                            "reach_multiplier": 1.75,
                            "attack_duration": float(AttackTimer),
                            "hit_delay_pct": round(float(DamageTimer) / float(AttackTimer), 2),
                            "track_target": False
                        },
                        "minecraft:movement": {
                            "value": 0.26
                        },
                        "minecraft:behavior.nearest_attackable_target": {
                            "priority": 2,
                            "must_see": True,
                            "reselect_targets": True,
                            "within_radius": 25.0,
                            "must_see_forget_duration": 17.0,
                            "entity_types": [
                                {
                                    "filters": {
                                        "any_of": [
                                            {
                                                "test": "is_family",
                                                "subject": "other",
                                                "value": "player"
                                            }
                                        ]
                                    },
                                    "max_dist": 35
                                }
                            ]
                        }
                    }
                },
                "components": {
                    "minecraft:damage_sensor": {
                        "triggers": {
                            "cause": "fall",
                            "deals_damage": False
                        }
                    },
                    "minecraft:behavior.random_stroll": {
                        "priority": 7,
                        "speed_multiplier": 1
                    },
                    "minecraft:behavior.look_at_player": {
                        "priority": 8,
                        "look_distance": 6,
                        "probability": 0.02
                    },
                    "minecraft:behavior.random_look_around": {
                        "priority": 9
                    },
                    "minecraft:follow_range": {
                        "value": 32
                    },
                    "minecraft:on_hurt": {
                        "event": "dfm:is_hurt",
                        "target": "self"
                    },
                    "minecraft:experience_reward": {
                        "on_death": "query.last_hit_by_player ? Math.Random(2,4) + (query.equipment_count * Math.Random(3,8)) : 0"
                    },
                    "minecraft:nameable": {
                        "always_show": True
                    },
                    "minecraft:scale": {
                        "value": float(Scale)
                    },
                    "minecraft:health": {
                        "value": int(Health),
                        "max": int(Health)
                    },
                    "minecraft:knockback_resistance": {
                        "value": 2.0
                    },
                    "minecraft:hurt_on_condition": {
                        "damage_conditions": [
                            {
                                "filters": {
                                    "test": "in_lava",
                                    "subject": "self",
                                    "operator": "==",
                                    "value": True
                                },
                                "cause": "lava",
                                "damage_per_tick": 4
                            }
                        ]
                    },
                    "minecraft:physics": {},
                    "minecraft:pushable": {
                        "is_pushable": True,
                        "is_pushable_by_piston": True
                    },
                    "minecraft:conditional_bandwidth_optimization": {}
                },
                "events": {
                    "dfm:is_hurt": {
                        "add": {
                            "component_groups": [
                                "dfm:is_hurt"
                            ]
                        },
                        "remove": {
                            "component_groups": [
                                "dfm:normal_state", "dfm:try_to_attack"
                            ]
                        }
                    },
                    "dfm:attack_cd": {
                        "add": {
                            "component_groups": [
                                "dfm:attack_cd"
                            ]
                        },
                        "remove": {
                            "component_groups": [
                                "dfm:normal_state", "dfm:try_to_attack"
                            ]
                        }
                    },
                    "dfm:stop_attack_cd_and_try_to_attack": {
                        "add": {
                            "component_groups": [
                                "dfm:normal_state", "dfm:try_to_attack"
                            ]
                        },
                        "remove": {
                            "component_groups": [
                                "attack_cd"
                            ]
                        }
                    },
                    "minecraft:entity_spawned": {
                        "add": {
                            "component_groups": [
                                "dfm:start"
                            ]
                        }
                    },
                    "dfm:start": {
                        "add": {
                            "component_groups": [
                                "dfm:alive", "dfm:normal_state", "dfm:try_to_attack"
                            ]
                        },
                        "remove": {
                            "component_groups": [
                                "dfm:start"
                            ]
                        }
                    },
                    "dfm:death": {
                        "add": {
                            "component_groups": [
                                "dfm:death"
                            ]
                        },
                        "remove": {
                            "component_groups": [
                                "dfm:alive"
                            ]
                        }
                    },
                    "dfm:stop_hurt": {
                        "remove": {
                            "component_groups": [
                                "dfm:is_hurt"
                            ]
                        }
                    },
                    "dfm:try_to_attack": {
                        "add": {
                            "component_groups": [
                                "dfm:normal_state", "dfm:try_to_attack"
                            ]
                        }
                    },
                    "dfm:stop_attack": {
                        "remove": {
                            "component_groups": [
                                "dfm:normal_state", "dfm:try_to_attack", "attack_cd"
                            ]
                        }
                    }
                }
            }
        }
        return JsonDemo

    def GetBPCustomComboEntityJsonDemo2(self, NameSpace, EntityName, Health, Scale, Width, Height, Damage, AttackTimer, DamageTimer):
        JsonDemo = {
            "format_version": "1.20.0",
            "minecraft:entity": {
                "description": {
                    "identifier": f"{NameSpace}:{EntityName}",
                    "is_spawnable": True,
                    "is_summonable": True,
                    "is_experimental": False
                },
                "component_groups": {
                    "dfm:start": {
                        "minecraft:is_tamed": {},
                        "minecraft:damage_sensor": {
                            "triggers": {
                                "cause": "fall2",
                                "deals_damage": False
                            }
                        },
                        "minecraft:timer": {
                            "looping": False,
                            "time": 2.2,
                            "time_down_event": {
                                "event": "dfm:start"
                            }
                        }
                    },
                    "dfm:is_hurt": {
                        "minecraft:is_shaking": {},
                        "minecraft:movement": {
                            "value": 0.00
                        }
                    },
                    "dfm:attack_cd": {
                        "minecraft:movement": {
                            "value": 0.00
                        },
                        "minecraft:timer": {
                            "looping": False,
                            "time": 3,
                            "time_down_event": {
                                "event": "dfm:stop_attack_cd_and_try_to_attack"
                            }
                        }
                    },
                    "dfm:death": {
                        "minecraft:transformation": {
                            "into": f"dfm:{EntityName}_death",
                            "drop_equipment": True,
                            "delay": {
                                "value": 0
                            }
                        }
                    },
                    "dfm:alive": {
                        "minecraft:breathable": {
                            "total_supply": 15,
                            "suffocate_time": 0,
                            "breathes_air": True,
                            "breathes_water": False
                        },
                        "minecraft:follow_range": {
                            "value": 32
                        },
                        "minecraft:type_family": {
                            "family": [
                                "monster",
                                "mob"
                            ]
                        },
                        "minecraft:behavior.hurt_by_target": {
                            "hurt_owner": True,
                            "entity_types": [
                                {
                                    "filters": {
                                        "any_of": [
                                            {
                                                "test": "is_family",
                                                "subject": "other",
                                                "operator": "!=",
                                                "value": "monster"
                                            }
                                        ]
                                    },
                                    "max_dist": 35
                                }
                            ]
                        },
                        "minecraft:collision_box": {
                            "width": float(Width),
                            "height": float(Height)
                        }
                    },
                    "dfm:normal_state": {
                        "minecraft:behavior.look_at_player": {
                            "priority": 8,
                            "look_distance": 6,
                            "probability": 0.02
                        },
                        "minecraft:behavior.random_look_around": {
                            "priority": 9
                        },
                        "minecraft:behavior.float": {},
                        "minecraft:movement.basic": {},
                        "minecraft:navigation.walk": {
                            "is_amphibious": True,
                            "can_path_over_water": True,
                            "can_pass_doors": True,
                            "can_open_doors": True,
                            "can_walk": True,
                            "avoid_water": False
                        },
                        "minecraft:annotation.open_door": {},
                        "minecraft:jump.static": {}
                    },
                    "dfm:try_to_attack": {
                        "minecraft:attack": {
                            "damage": int(Damage)
                        },
                        "minecraft:behavior.delayed_attack": {
                            "priority": 3,
                            "speed_multiplier": 1.1,
                            "attack_once": False,
                            "require_complete_path": False,
                            "reach_multiplier": 1.75,
                            "attack_duration": float(AttackTimer),
                            "hit_delay_pct": round(float(DamageTimer) / float(AttackTimer), 2),
                            "track_target": False
                        },
                        "minecraft:movement": {
                            "value": 0.26
                        },
                        "minecraft:behavior.nearest_attackable_target": {
                            "priority": 2,
                            "must_see": True,
                            "reselect_targets": True,
                            "within_radius": 25.0,
                            "must_see_forget_duration": 17.0,
                            "entity_types": [
                                {
                                    "filters": {
                                        "any_of": [
                                            {
                                                "test": "is_family",
                                                "subject": "other",
                                                "value": "player"
                                            }
                                        ]
                                    },
                                    "max_dist": 35
                                }
                            ]
                        }
                    }
                },
                "components": {
                    "minecraft:damage_sensor": {
                        "triggers": {
                            "cause": "fall",
                            "deals_damage": False
                        }
                    },
                    "minecraft:on_hurt": {
                        "event": "dfm:is_hurt",
                        "target": "self"
                    },
                    "minecraft:experience_reward": {
                        "on_death": "query.last_hit_by_player ? Math.Random(2,4) + (query.equipment_count * Math.Random(3,8)) : 0"
                    },
                    "minecraft:nameable": {
                        "always_show": True
                    },
                    "minecraft:scale": {
                        "value": float(Scale)
                    },
                    "minecraft:health": {
                        "value": int(Health),
                        "max": int(Health)
                    },
                    "minecraft:knockback_resistance": {
                        "value": 2.0
                    },
                    "minecraft:hurt_on_condition": {
                        "damage_conditions": [
                            {
                                "filters": {
                                    "test": "in_lava",
                                    "subject": "self",
                                    "operator": "==",
                                    "value": True
                                },
                                "cause": "lava",
                                "damage_per_tick": 4
                            }
                        ]
                    },
                    "minecraft:physics": {},
                    "minecraft:pushable": {
                        "is_pushable": True,
                        "is_pushable_by_piston": True
                    },
                    "minecraft:conditional_bandwidth_optimization": {}
                },
                "events": {
                    "dfm:is_hurt": {
                        "add": {
                            "component_groups": [
                                "dfm:is_hurt"
                            ]
                        },
                        "remove": {
                            "component_groups": [
                                "dfm:normal_state", "dfm:try_to_attack"
                            ]
                        }
                    },
                    "dfm:attack_cd": {
                        "add": {
                            "component_groups": [
                                "dfm:attack_cd"
                            ]
                        },
                        "remove": {
                            "component_groups": [
                                "dfm:normal_state", "dfm:try_to_attack"
                            ]
                        }
                    },
                    "dfm:stop_attack_cd_and_try_to_attack": {
                        "add": {
                            "component_groups": [
                                "dfm:normal_state", "dfm:try_to_attack"
                            ]
                        },
                        "remove": {
                            "component_groups": [
                                "attack_cd"
                            ]
                        }
                    },
                    "minecraft:entity_spawned": {
                        "add": {
                            "component_groups": [
                                "dfm:start"
                            ]
                        }
                    },
                    "dfm:start": {
                        "add": {
                            "component_groups": [
                                "dfm:alive", "dfm:normal_state", "dfm:try_to_attack"
                            ]
                        },
                        "remove": {
                            "component_groups": [
                                "dfm:start"
                            ]
                        }
                    },
                    "dfm:death": {
                        "add": {
                            "component_groups": [
                                "dfm:death"
                            ]
                        },
                        "remove": {
                            "component_groups": [
                                "dfm:alive"
                            ]
                        }
                    },
                    "dfm:stop_hurt": {
                        "remove": {
                            "component_groups": [
                                "dfm:is_hurt"
                            ]
                        }
                    },
                    "dfm:try_to_attack": {
                        "add": {
                            "component_groups": [
                                "dfm:normal_state", "dfm:try_to_attack"
                            ]
                        }
                    },
                    "dfm:stop_attack": {
                        "remove": {
                            "component_groups": [
                                "dfm:normal_state", "dfm:try_to_attack", "attack_cd"
                            ]
                        }
                    }
                }
            }
        }
        return JsonDemo

    def GetBPAirEntityJsonDemo(self):
        JsonDemo = {
            "format_version": "1.14.0",
            "minecraft:entity": {
                "description": {
                    "identifier": "dfm:air",
                    "is_spawnable": False,
                    "is_summonable": True,
                    "is_experimental": False
                },
                "component_groups": {
                    "dfm:xiaoshi": {
                        "minecraft:despawn": {}
                    }
                },
                "components": {
                    "minecraft:type_family": {
                        "family": [
                            "none"
                        ]
                    },
                    "minecraft:timer": {
                        "looping": False,
                        "time": 1,
                        "time_down_event": {
                            "event": "dfm:xiaoshi"
                        }
                    },
                    "minecraft:health": {
                        "value": 1,
                        "max": 1
                    },
                    "minecraft:movement": {
                        "value": 0.35
                    },
                    "minecraft:movement.basic": {},
                    "minecraft:navigation.walk": {
                    },
                    "minecraft:damage_sensor": {
                        "triggers": {
                            "cause": "fall2",
                            "deals_damage": False
                        }
                    },
                    "minecraft:collision_box": {
                        "width": 0.1,
                        "height": 0.1
                    },
                    "minecraft:pushable": {
                        "is_pushable": True,
                        "is_pushable_by_piston": True
                    },
                    "minecraft:scale": {
                        "value": 1.0
                    },
                    "minecraft:physics": {}
                },
                "events": {
                    "dfm:xiaoshi": {
                        "add": {
                            "component_groups": [
                                "dfm:xiaoshi"
                            ]
                        }
                    }
                }
            }
        }
        return JsonDemo

    def GetBPCustomBossDeathEntityJsonDemo(self, NameSpace, EntityName, Health, Scale, *args):
        JsonDemo = {
            "format_version": "1.14.0",
            "minecraft:entity": {
                "description": {
                    "identifier": f"{NameSpace}:{EntityName}_death",
                    "is_spawnable": False,
                    "is_summonable": True,
                    "is_experimental": False
                },
                "component_groups": {
                    "dfm:to_air": {
                        "minecraft:transformation": {
                            "into": "dfm:air",
                            "drop_equipment": True,
                            "delay": {
                                "value": 0
                            }
                        }
                    }
                },
                "components": {
                    "minecraft:scale": {
                        "value": float(Scale)
                    },
                    "minecraft:experience_reward": {
                        "on_death": "query.last_hit_by_player ? Math.Random(2,4) + (query.equipment_count * Math.Random(3,8)) : 0"
                    },
                    "minecraft:collision_box": {
                        "width": 0.01,
                        "height": 0.01
                    },
                    "minecraft:timer": {
                        "looping": False,
                        "time": 3,
                        "time_down_event": {
                            "event": "dfm:to_air"
                        }
                    },
                    "minecraft:despawn": {
                        "despawn_from_distance": {}
                    },
                    "minecraft:nameable": {
                        "always_show": True
                    },
                    "minecraft:health": {
                        "value": 1,
                        "max": 1
                    },
                    "minecraft:damage_sensor": {
                        "triggers": {
                            "cause": "fall2",
                            "deals_damage": False
                        }
                    },
                    "minecraft:physics": {},
                    "minecraft:pushable": {
                        "is_pushable": False,
                        "is_pushable_by_piston": False
                    },
                    "minecraft:conditional_bandwidth_optimization": {}
                },
                "events": {
                    "dfm:to_air": {
                        "add": {
                            "component_groups": [
                                "dfm:to_air"
                            ]
                        }
                    }
                }
            }
        }
        return JsonDemo

    def GetRPCustomComboEntityJsonDemo(self, NameSpace, EntityName):
        JsonDemo = {
            "format_version": "1.10.0",
            "minecraft:client_entity": {
                "description":{
                    "identifier": f"{NameSpace}:{EntityName}",
                    "spawn_egg": {
                    },
                    "render_controllers": [
                        "controller.render.all"
                    ],
                    "textures":{
                        "default": f"textures/entity/{EntityName}"
                    },
                    "geometry": {
                        "default": f"geometry.{EntityName}"
                    },
                    "animations": {
                        # add other animation this way.
                        "look_at_target": "animation.dfm_common.look_at_target",
                        "idle": f"animation.{EntityName}.idle",
                        "walk": f"animation.{EntityName}.walk",
                        "attack": f"animation.{EntityName}.attack",
                        "death": f"animation.{EntityName}.death",
                        "states_controller": f"controller.animation.{EntityName}.states"
                    },
                    "scripts": {
                        "animate": [
                            "look_at_target", "states_controller"
                        ]
                    },
                    "materials": {
                        "default": "spider"
                    }
                }
            }
        }
        return JsonDemo

    def GetRPCustomBossDeathEntityJsonDemo(self, NameSpace, EntityName):
        JsonDemo = {
            "format_version": "1.10.0",
            "minecraft:client_entity": {
                "description":{
                    "identifier": f"{NameSpace}:{EntityName}_death",
                    "render_controllers": [
                        "controller.render.all"
                    ],
                    "textures":{
                        "default": f"textures/entity/{EntityName}"
                    },
                    "geometry": {
                        "default": f"geometry.{EntityName}"
                    },
                    "animations": {
                        "idle": f"animation.{EntityName}.idle",
                        "walk": f"animation.{EntityName}.walk",
                        "attack": f"animation.{EntityName}.attack",
                        "death": f"animation.{EntityName}.death",
                        "states_controller": "controller.animation.xiaobing.states"
                    },
                    "scripts": {
                        "animate": [
                            "death"
                        ]
                    },
                    "materials": {
                        "default": "spider"
                    }
                }
            }
        }
        return JsonDemo

    def GetRPCustomBossAnimationControllersJsonDemo(self, NameSpace, EntityName):
        JsonDemo = {
            "format_version": "1.10.0",
            "animation_controllers": {
                f"controller.animation.{EntityName}.states":{
                    "initial_state": "idle",
                    "states": {
                        "combo_attack": {
                            "animations": [
                                {
                                    "custom_combo_attack": "query.mod.combo == 1"
                                }
                            ],
                            "transitions": [
                                {
                                    "idle": "!query.mod.combo"
                                }
                            ],
                            "blend_transition": 0.15
                        },
                        "idle": {
                            "animations": ["idle"],
                            "transitions": [
                                {
                                    "walk": "query.ground_speed > 0"
                                },
                                {
                                    "attacked": "query.is_shaking"
                                },
                                {
                                    "attack": "query.is_delayed_attacking"
                                },
                                {
                                    "combo_attack": "query.mod.combo"
                                },
                                {
                                    "houtui": "query.mod.houtui"
                                },
                                {
                                    "tianshe": "query.mod.tianshe"
                                }
                            ],
                            "blend_transition": 0.15
                        },
                        "walk": {
                            "animations": ["walk"],
                            "transitions": [
                                {
                                    "idle": "query.ground_speed <= 0"
                                },
                                {
                                    "attacked": "query.is_shaking"
                                },
                                {
                                    "attack": "query.is_delayed_attacking"
                                },
                                {
                                    "combo_attack": "query.mod.combo"
                                },
                                {
                                    "houtui": "query.mod.houtui"
                                },
                                {
                                    "tianshe": "query.mod.tianshe"
                                }
                            ],
                            "blend_transition": 0.15
                        },
                        "houtui": {
                            "animations": ["jiguang"],
                            "transitions": [
                                {
                                    "idle": "!query.mod.houtui"
                                },
                                {
                                    "attacked": "query.is_shaking"
                                },
                                {
                                    "tianshe": "query.mod.tianshe"
                                }
                            ],
                            "blend_transition": 0
                        },
                        "tianshe": {
                            "animations": ["zadi"],
                            "transitions": [
                                {
                                    "idle": "!query.mod.tianshe"
                                }
                            ],
                            "blend_transition": 0
                        },
                        "attack": {
                            "animations": ["attack"],
                            "transitions": [
                                {
                                    "idle": "!query.is_delayed_attacking"
                                },
                                {
                                    "attacked": "query.is_shaking"
                                },
                                {
                                    "combo_attack": "query.mod.combo"
                                },
                                {
                                    "houtui": "query.mod.houtui"
                                }
                            ],
                            "blend_transition": 0.15
                        },
                        "attacked": {
                            "animations": ["attacked"],
                            "transitions": [
                                {
                                    "idle": "query.any_animation_finished"
                                },
                                {
                                    "tianshe": "query.mod.tianshe"
                                }
                            ],
                            "blend_transition": 0.15
                        }
                    }
                }
            }
        }
        return JsonDemo

    def GetRPBatteryRenderControllerJsonDemo(self):
        JsonDemo = {
            "format_version": "1.8.0",
            "render_controllers": {
                "controller.render.all": {
                    "geometry": "Geometry.default",
                    "materials": [
                        {"*": "Material.default"}
                    ],
                    "textures": ["Texture.default"]
                }
            }
        }
        return JsonDemo

